/*
VALDUINO PLC Midi V2
Dijital inputs : A1,A2, A3, 3, 4
Analog inputs : A6,A7
Dijital Outputs : 9, 8, 7, 6, 5
SPI : SS:10, MOSI:11, MISO:12, SCK:13
RS485 : RXE:0, TXE:1, DE:A0
I2C : SDA:A4, SCE:A5, INT:2
*/

#include <EEPROM.h>
#include <SPI.h>
#include <Ethernet.h>

int AIN0, AIN1; // analog inputs
int IN0, IN1, IN2, IN3, IN4; // inputs
int OUT0 = 9;
int OUT1 = 8;
int OUT2 = 7;
int OUT3 = 6;
int OUT4 = 5;

void setup() {
  Serial.begin(9600);

  pinMode(A1, INPUT); // IN0
  pinMode(A2, INPUT); // IN1
  pinMode(A3, INPUT); // IN2
  pinMode(3, INPUT); //IN3
  pinMode(4, INPUT); //IN4
  pinMode(A6, INPUT); // analog A0
  pinMode(A7, INPUT); // analog A1

  pinMode(OUT0, OUTPUT); // OUT0
  pinMode(OUT1, OUTPUT); //OUT1
  pinMode(OUT2, OUTPUT); //OUT2
  pinMode(OUT3, OUTPUT); //OUT3
  pinMode(OUT4, OUTPUT); //OUT4

}

// the loop function runs over and over again forever
void loop() {
  // inputs read
  input_read();

  if (IN0 == 1) {digitalWrite(OUT0, 1);} // test için girişi çıkışa verir
  else digitalWrite(OUT0, 0);

  if (IN1 == 1){digitalWrite(OUT1, 1);} // test için girişi çıkışa verir
  else digitalWrite(OUT1, 0);
  
  if (IN2 == 1) {digitalWrite(OUT2, 1);} // test için girişi çıkışa verir
  else digitalWrite(OUT2, 0);
  
  if (IN3 == 1) {digitalWrite(OUT3, 1);} // test için girişi çıkışa verir
  else digitalWrite(OUT3, 0);

  if (IN4 == 1) {digitalWrite(OUT4, 1);} // test için girişi çıkışa verir
  else digitalWrite(OUT4, 0);


// analog girişleri serialden okuyun
Serial.print("AIN0:");
Serial.print(AIN0); 
Serial.print("\t");
Serial.print("AIN1:");
Serial.println(AIN1);

}
void input_read()
{
 AIN0 = analogRead(A6); // 0-10V--0-1023
 AIN1 = analogRead(A7); // 0-10V--0-1023
 IN0 = digitalRead(A1); 
 IN1 = digitalRead(A2);
 IN2 = digitalRead(A3);
 IN3 = digitalRead(3);
 IN4 = digitalRead(4);
}
